

#define pictstringlist 167
#define picttypestring 1
#define picttextstring 2
#define pictsizestring 3
#define picterrorstring 5



typedef struct typictrecord {
	
	PicHandle macpicture; /*the structure that's passed off to DrawPicture*/
	
	Rect windowrect; /*the size of the window that last displayed this pict*/
	
	long timecreated, timelastsave; /*maybe we'll use these at some later date?*/
	
	long ctsaves; /*the number of times this structure has been saved*/
	
	short updateticks; /*how many ticks between updates when window is in front*/
	
	long timelastupdate; /*last time this pict was updated*/
	
	long pictrefcon; /*could be anything -- we don't care*/

	boolean fldirty: 1; /*maybe someday we'll have a pict editor*/
	
	boolean fllocked: 1; /*are changes allowed to be made?*/
	
	boolean flwindowopen: 1; /*true if the record is being edited in a window*/
	
	boolean flbitmapupdate: 1; /*if true, use offscreen bitmap when updating*/
	
	boolean flevalexpressions: 1; /*if true, parse all text that begins with an = sign*/
	
	boolean flscaletofitwindow: 1; /*if true, scale window down to fit inside window*/
	
	} typictrecord, *ptrpictrecord, **hdlpictrecord;
	
	
extern WindowPtr pictwindow;

extern hdlwindowinfo pictwindowinfo;

extern hdlpictrecord pictdata;


/*prototypes*/


extern void pictdirty (void);

extern boolean pictgetframerect (hdlpictrecord, Rect *);

extern boolean pictpack (hdlpictrecord, Handle *);

extern boolean pictunpack (Handle, long *, hdlpictrecord *);

extern boolean pictnewrecord (void);

extern boolean pictdisposerecord (hdlpictrecord);

extern boolean pictreadfile (bigstring, PicHandle *);

extern void pictresetscrollbars (void);

extern boolean pictscroll (tydirection, boolean, long);

extern void pictupdatepatcher (void);

extern void pictdepatcher (void);

extern void pictupdate (void);

extern void pictidle (void);

extern void pictscheduleupdate (short);

extern void pictsetbitmapupdate (boolean);

extern void pictsetevaluate (boolean);

extern void pictgetnewwindowrect (hdlpictrecord, Rect *);




